using System;
using System.Collections.Generic;
using System.Linq;

public class Ponco
{
    public int Rbr { get; set; }
    public long T { get; set; }
    public long V { get; set; }
}

public struct Podskup
{
    public long T;
    public long V;
    public List<int> I;

    public Podskup(long t, long v, List<int> i)
    {
        T = t;
        V = v;
        I = i;
    }
}

public class Program
{
    private static List<Podskup> GenerisiPds(List<Ponco> p)
    {
        List<Podskup> rez = new List<Podskup>();
        int n = p.Count;

        for (int i = 0; i < (1 << n); i++)
        {
            long currT = 0;
            long currV = 0;
            List<int> izabraniI = new List<int>();

            for (int j = 0; j < n; j++)
            {
                if (((i >> j) & 1) == 1)
                {
                    currT += p[j].T;
                    currV += p[j].V;
                    izabraniI.Add(p[j].Rbr);
                }
            }
            rez.Add(new Podskup(currT, currV, izabraniI));
        }
        return rez;
    }

    public static void Main()
    {
        System.Threading.Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo("en-US");

        string[] pL = Console.ReadLine().Split();
        int N = int.Parse(pL[0]);
        long W = long.Parse(pL[1]);

        List<Ponco> sviP = new List<Ponco>();

        for (int i = 0; i < N; i++)
        {
            string[] linija = Console.ReadLine().Split();
            long t = long.Parse(linija[0]);
            long v = long.Parse(linija[1]);

            sviP.Add(new Ponco { Rbr = i + 1, T = t, V = v });
        }

        // --- MITM Algoritam ---

        int N1 = N / 2;
        List<Ponco> pPol = sviP.GetRange(0, N1);
        List<Ponco> dPol = sviP.GetRange(N1, N - N1);

        List<Podskup> pds1 = GenerisiPds(pPol);
        List<Podskup> pds2 = GenerisiPds(dPol);

        pds1 = pds1.Where(p => p.T <= W).OrderBy(p => p.T).ToList();

        List<Podskup> opt1 = new List<Podskup>();
        long currMaxV = -1;
        foreach (var p in pds1)
        {
            if (p.V > currMaxV)
            {
                opt1.Add(p);
                currMaxV = p.V;
            }
        }

        long maxV = 0;
        List<int> bestI = new List<int>();

        foreach (var p2 in pds2)
        {
            if (p2.T <= W)
            {
                long preostalaT = W - p2.T;

                int l = 0;
                int d = opt1.Count - 1;
                int bestI1 = -1;

                while (l <= d)
                {
                    int sr = l + (d - l) / 2;
                    if (opt1[sr].T <= preostalaT)
                    {
                        bestI1 = sr;
                        l = sr + 1;
                    }
                    else
                    {
                        d = sr - 1;
                    }
                }

                if (bestI1 != -1)
                {
                    Podskup p1 = opt1[bestI1];
                    long ukupnaV = p1.V + p2.V;

                    if (ukupnaV > maxV)
                    {
                        maxV = ukupnaV;
                        bestI = p1.I.Concat(p2.I).ToList();
                    }
                }
            }
        }

        Console.WriteLine(bestI.Count);
        Console.WriteLine(string.Join(" ", bestI));
    }
}